#pragma once

/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////
#include "ShTarget.h"
#include "Config.h"
/////////////////////////////////////////////////////////////////////////////
// CConfigDlg dialog
class CConfig;
/////////////////////////////////////////////////////////////////////////////
class COMMON_API CConfigDlg : public CDialog
{
	DECLARE_DYNAMIC(CConfigDlg)

private:
	virtual int		GetIconId()		{ return NULL; };
public:
	CConfigDlg(UInt16 iDlgID, HINSTANCE iHInst, CConfig* iCfgP, void* iParamP=NULL);
	virtual ~CConfigDlg();
	virtual void		UpdateDisplay()=0;
	virtual char*		GetName()=0;
	virtual BOOL		ShowWindow( int nCmdShow );
	virtual BOOL		Apply()=0;
	// Extended dlg 
	virtual int			GetExtDlgCount()		{ return 0; };
	virtual CConfigDlg*	GetExtDlgUI(int iId)	{ return NULL; };
	//
	void				OnUpdate(WPARAM iWItemChanged, LPARAM iLReason);	
	BOOL				Init(CWnd *iParentP);
	HICON				GetIcon();
	BOOL				IsExtended()			{ return mExtended; };
	void				SetId(int iId)			{ mId = iId; };
	int					GetId()					{ return mId;};
	//
	BOOL				mInited;
protected:
	HINSTANCE			mHInst;
	int					mDlgId;
	int					mId;		// used to identify dlg in the tree
	BOOL				mExtended;
	CConfig*			mConfigP;
	void*				mParamP;
protected:
	virtual void		DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()
	afx_msg void		OnDestroy()			{ mInited = false; };
	afx_msg void		OnChange();
	// to prevent dialog closing on enter and esc key
	afx_msg void		OnOK();
	afx_msg void		OnCancel();
};
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////